package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class Complement extends Function1in1fatOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/ComplementIcon.gif");
	
	public Image getIcon()
	{
		return Complement.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Complement";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Complement()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		Complement result = new Complement();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			
			g.setColor(this.brush);
			
			g.drawRect(0, gridGap, 2 * gridGap - 1, 2* gridGap - 1);
			
			g.fillRect(gridGap - 1, 0, 3, gridGap);
			g.fillRect(gridGap - 1, 3 * gridGap, 3, gridGap);
			
			g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * increment));
			
			FontMetrics fm = g.getFontMetrics(g.getFont());
			g.drawString("not", gridGap - fm.stringWidth("not") / 2, 2 * gridGap + fm.getAscent() / 2);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		int loop;
		int value = 0;
		int base = 1;
		boolean foundUndefined = false;
		String bitValue;
		
		for(loop = 0; (loop < this.busSize) && (!foundUndefined); loop++)
		{
			if(currentInputs[loop].isUndefined())
				foundUndefined = true;
			else if(currentInputs[loop].getValue())
				value = value + base;
			
			base = 2 * base;
		}
		
		if(foundUndefined)
		{
			for(loop = 0; loop < this.busSize;loop++)
				peer.setOutputPinUndefined(loop, time);
		}
		else
		{
			value = (int)Math.pow(2, this.busSize) - 1 - value;
			
			bitValue = Integer.toBinaryString(value);
			
			for(loop = bitValue.length(); loop <  this.busSize; loop ++)
				bitValue = "0" + bitValue;
			
			for(loop = 0; loop < this.busSize; loop++)
				peer.setOutputPinValue(loop, bitValue.charAt(this.busSize - 1 - loop) == '1', time);
		}
	}
}