package sim;

import java.awt.*;
import gjt.BulletinLayout;

public class ScrollCanvas extends ScrollPane
{
	public static int INSET = 10;
	
	public ScrollCanvas(String fileName)
	{
		super(ScrollPane.SCROLLBARS_AS_NEEDED);
		
		this.getHAdjustable().setUnitIncrement(16);
		this.getVAdjustable().setUnitIncrement(16);
		this.setBackground(Color.white);
		
		this.add(new GridPanel(this, fileName));
	}
	
	public void update(Graphics g)
	{ 
		this.paint(g);
	}
	
	public void realUpdate()
	{ 
		((GridPanel)this.getComponent(0)).realUpdate();
	}
	
/* ======================================================================
	Implement Panel to hold Grid
	===================================================================== */
	
	public class GridPanel extends Panel
	{
		public GridPanel(ScrollCanvas sp, String fileName)
		{
			super();
			
			this.setLayout(new BulletinLayout());
			this.add(new Grid(sp, fileName));
		}
		
		public Dimension getPrefferedSize()
		{
			return ((Grid)this.getComponent(0)).getCurrentSize();
		}
		
		public void update(Graphics g)
		{
		}
		
		public void realUpdate()
		{ 
			super.update(this.getGraphics());
		}
	}
}
