package sim.lib.functions;

import java.awt.*;
import java.awt.event.*;

import sim.util.SimSeparator;

public class FunctionProperty extends Container implements ActionListener, FocusListener
{
	private TextField editBus = new TextField(10);
	private TextField editDelay = new TextField(10);
	private double oldDelay;
	private int oldBus;
	
	private Label pins = new Label("Pins");
	private Label simulation = new Label("Simulation");
	
	public FunctionProperty(int bus, double delay)
	{
		super();
		this.setLayout(new BorderLayout(0, 15));
		
		this.oldBus = bus;
		this.editBus.addActionListener(this);
		this.editBus.addFocusListener(this);
		this.editBus.setText(Integer.toString(bus));
		
		this.oldDelay = delay;
		this.editDelay.addActionListener(this);
		this.editDelay.addFocusListener(this);
		this.editDelay.setText(Double.toString(delay));
		
		Panel big = new Panel(new BorderLayout(0, 15));
		Panel p = new Panel(new BorderLayout());
		p.add(this.pins, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		big.add(p, BorderLayout.NORTH);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Bus Size"));
		p.add(this.editBus);
		big.add(p, BorderLayout.CENTER);
		
		this.add(big, BorderLayout.NORTH);
		
		big = new Panel(new BorderLayout(0, 15));
		p = new Panel(new BorderLayout());
		p.add(this.simulation, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		big.add(p, BorderLayout.NORTH);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Propagation Delay"));
		p.add(this.editDelay);
		big.add(p, BorderLayout.CENTER);
		
		this.add(big, BorderLayout.CENTER);
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.setSize(290, this.editBus.getPreferredSize().height * 2 + this.pins.getPreferredSize().height * 2 + 45);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		TextField source = (TextField)e.getSource();
		
		if(source == this.editDelay)
			this.getDelay();
		else if(source == this.editBus)
			this.getBusSize();
	}
	
	public void focusGained(FocusEvent e)
	{
	}
	
	public void focusLost(FocusEvent e)
	{
		TextField source = (TextField)e.getSource();
		
		if(source == this.editDelay)
			this.getDelay();
		else if(source == this.editBus)
			this.getBusSize();
		
		source.setText(source.getText());
	}
	
	public int getBusSize()
	{
		int newBus;
		
		try
		{
			newBus = Integer.valueOf(this.editBus.getText()).intValue();
			
			if(newBus > 1)
				this.oldBus = newBus;
			else
				this.editBus.setText(Integer.toString(this.oldBus));
		}
		catch(NumberFormatException nfe)
		{
			this.editBus.setText(Integer.toString(this.oldBus));
		}
		
		return this.oldBus;
	}
	
	public double getDelay()
	{
		double newDelay;
		
		try
		{
			newDelay = Double.valueOf(this.editDelay.getText()).doubleValue();
			
			if(newDelay >= 0)
				this.oldDelay = newDelay;
			else
				this.editDelay.setText(Double.toString(this.oldBus));
		}
		catch(NumberFormatException nfe)
		{
			this.editDelay.setText(Double.toString(this.oldBus));
		}
		
		return this.oldDelay;
	}
	
	public Dimension getPreferredSize()
	{
		return this.getSize();
	}
	
	public Dimension getMinimumSize()
	{
		return this.getSize();
	}

	public Dimension getMaximumSize()
	{
		return this.getSize();
	}
}