package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class ShiftLeft extends Function1in1fat1thinOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/ShiftLeftIcon.gif");
	
	public Image getIcon()
	{
		return ShiftLeft.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Shift left";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public ShiftLeft()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		ShiftLeft result = new ShiftLeft();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			int twice = 2 * gridGap;
			
			g.setColor(this.brush);
			
			g.drawRect(gridGap, gridGap, twice, twice);
			
			g.drawLine(0, 2 * gridGap, gridGap, twice);
			g.fillRect(twice - 1, 0, 3, gridGap);
			g.fillRect(twice - 1, 3 * gridGap, 3, gridGap);
			
			g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * increment));
			
			FontMetrics fm = g.getFontMetrics(g.getFont());
			g.drawString("<<", twice - fm.stringWidth("<<") / 2, twice + fm.getAscent() / 2);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		peer.setOutputPinValue(0, false, time);
		
		for(int loop = 1; loop <= this.busSize; loop++)
		{
			if(currentInputs[loop - 1].isUndefined())
				peer.setOutputPinUndefined(loop, time);
			else
				peer.setOutputPinValue(loop, currentInputs[loop - 1].getValue(), time);
		}
		
	}
}