package sim.lib;

import java.applet.*;

import sim.*;

import sim.lib.gates.GateAND;
import sim.lib.gates.GateOR;
import sim.lib.gates.GateNAND;
import sim.lib.gates.GateNOR;
import sim.lib.gates.GateNOT;
import sim.lib.gates.GateXOR;
import sim.lib.others.TristateBuffer;
import sim.lib.sorces.Clock;
import sim.lib.others.PulseGenerator;
import sim.lib.sorces.Constant;
import sim.lib.sorces.BusConstant;
import sim.lib.wires.Fat2ThinFullSplitter;
import sim.lib.outputs.Led;
import sim.lib.outputs.BusLed;
import sim.lib.memory.JKflipflop;
import sim.lib.memory.Dflipflop;
import sim.lib.others.Multiplexer;
import sim.lib.others.Demultiplexer;
import sim.lib.others.FullAdder;
import sim.lib.others.HalfAdder;
import sim.lib.memory.Ram;
import sim.lib.memory.Rom;
import sim.lib.memory.ShiftRegister;
import sim.lib.memory.Register;
import sim.lib.functions.Increment;
import sim.lib.functions.Decrement;
import sim.lib.functions.Negate;
import sim.lib.functions.Complement;
import sim.lib.functions.ShiftLeft;
import sim.lib.functions.ShiftRight;
import sim.lib.functions.EqualTo;
import sim.lib.functions.NotEqualTo;
import sim.lib.functions.LessThan;
import sim.lib.functions.LessOrEqualThan;
import sim.lib.functions.GreaterThan;
import sim.lib.functions.GreaterOrEqualThan;
import sim.lib.functions.Add;
import sim.lib.functions.Minus;
import sim.lib.functions.Multiply;
import sim.lib.functions.Divide;
import sim.lib.functions.BitwiseAnd;
import sim.lib.functions.BitwiseOr;
import sim.lib.functions.BitwiseXor;
import sim.lib.functions.Equal;
import sim.lib.functions.NotEqual;
import sim.lib.functions.Less;
import sim.lib.functions.LessOrEqual;
import sim.lib.functions.Greater;
import sim.lib.functions.GreaterOrEqual;

public class RtlModulePanel extends ModulePanel
{
	public RtlModulePanel()
	{
		super();
	}
	
	protected void initialize()
	{
		this.add(new ModuleButton(new GateNOT()));
		this.add(new ModuleButton(new GateXOR()));
		this.add(new ModuleButton(new GateAND()));
		this.add(new ModuleButton(new GateOR()));
		this.add(new ModuleButton(new GateNAND()));
		this.add(new ModuleButton(new GateNOR()));
		this.add(new ModuleButton(new TristateBuffer()));
		this.add(new ModuleButton(new Clock()));
		this.add(new ModuleButton(new PulseGenerator()));
		this.add(new ModuleButton(new Constant()));
		this.add(new ModuleButton(new BusConstant()));
		this.add(new ModuleButton(new Fat2ThinFullSplitter()));
		this.add(new ModuleButton(new Led()));
		this.add(new ModuleButton(new BusLed()));
		this.add(new ModuleButton(new JKflipflop()));
		this.add(new ModuleButton(new Dflipflop()));
		this.add(new ModuleButton(new Multiplexer()));
		this.add(new ModuleButton(new Demultiplexer()));
		this.add(new ModuleButton(new FullAdder()));
		this.add(new ModuleButton(new HalfAdder()));
		this.add(new ModuleButton(new Ram()));
		this.add(new ModuleButton(new Rom()));
		this.add(new ModuleButton(new ShiftRegister()));
		this.add(new ModuleButton(new Register()));
		this.add(new ModuleButton(new Increment()));
		this.add(new ModuleButton(new Decrement()));
		this.add(new ModuleButton(new Negate()));
		this.add(new ModuleButton(new Complement()));
		this.add(new ModuleButton(new ShiftLeft()));
		this.add(new ModuleButton(new ShiftRight()));
		this.add(new ModuleButton(new EqualTo()));
		this.add(new ModuleButton(new NotEqualTo()));
		this.add(new ModuleButton(new LessThan()));
		this.add(new ModuleButton(new LessOrEqualThan()));
		this.add(new ModuleButton(new GreaterThan()));
		this.add(new ModuleButton(new GreaterOrEqualThan()));
		this.add(new ModuleButton(new Add()));
		this.add(new ModuleButton(new Minus()));
		this.add(new ModuleButton(new Multiply()));
		this.add(new ModuleButton(new Divide()));
		this.add(new ModuleButton(new BitwiseAnd()));
		this.add(new ModuleButton(new BitwiseOr()));
		this.add(new ModuleButton(new BitwiseXor()));
		this.add(new ModuleButton(new Equal()));
		this.add(new ModuleButton(new NotEqual()));
		this.add(new ModuleButton(new Less()));
		this.add(new ModuleButton(new LessOrEqual()));
		this.add(new ModuleButton(new Greater()));
		this.add(new ModuleButton(new GreaterOrEqual()));
	}
}
