package sim.lib.functions;


import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public abstract class Function1in1fatOut extends Function
{
/* ==================================================================
	GUI part
	================================================================= */
	public Function1in1fatOut()
	{
		super();
	}
	
	public void initializeGridSize()
	{
		this.setGridSize(2, 4);
	}
	
/* ==================================================================
	Maintanance Part
	================================================================= */
	private Junction inputX = null;
	private Junction output = null;
	
	public boolean canDrop()
	{
		boolean result = Wrapper.canDropJuncion(this.gridLocation.x + 1, this.gridLocation.y, this.busSize);
		result = result && Wrapper.canDropJuncion(this.gridLocation.x + 1, this.gridLocation.y + 4, this.busSize);
		
		return result;
	}
		
	public void droped()
	{
		this.inputX = Wrapper.setPinAt(this.gridLocation.x + 1, this.gridLocation.y, this.busSize);
		this.output = Wrapper.setPinAt(this.gridLocation.x + 1, this.gridLocation.y + 4, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	public void selected()
	{
		this.output.removePin();
		this.inputX.removePin();
		
		this.changeColor(Color.green);
	}
	
	public void checkAfterSelected()
	{
		Wrapper.checkPin(this.output);
		Wrapper.checkPin(this.inputX);
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void createEnginePeer(EnginePeerList epl)
	{
		int loop;		
		EnginePeer ep = new EnginePeer(this.busSize, this.busSize, this);
		
		for(loop = 0; loop < this.busSize; loop++)
		{
			ep.setInputPin(loop, this.inputX.getNodes().getItemAt(loop));
			ep.setOutputPin(loop, this.output.getNodes().getItemAt(loop));
		}
		
		epl.insertItem(ep);
	}
}