package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class Less extends Function2in1thinOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/LessUnitIcon.gif");
	
	public Image getIcon()
	{
		return Less.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Less unit";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Less()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		Less result = new Less();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			int tripple = 3 * gridGap;
			
			g.setColor(this.brush);
			
			g.drawLine(gridGap + increment, gridGap, 10 * increment, gridGap);
			g.drawLine(14 * increment, gridGap, 19 * increment, gridGap);
			
			g.drawLine(10 * increment, gridGap, tripple, 6 * increment);
			g.drawLine(14 * increment, gridGap, tripple, 6 * increment);
			
			g.drawLine(gridGap + increment, tripple, 19 * increment, tripple);
			
			g.drawLine(gridGap + increment, gridGap, gridGap + increment, tripple);
			g.drawLine(19 * increment, gridGap, 19 * increment, tripple);
			
			g.fillRect(2 * gridGap - 1, 0, 3, gridGap);
			g.fillRect(4 * gridGap - 1, 0, 3, gridGap);
			g.drawLine(tripple, tripple, tripple, tripple + gridGap);
			
			g.drawLine(tripple - increment, 9 * increment, tripple + increment, tripple - gridGap);
			g.drawLine(tripple - increment + 1, 9 * increment + 1, tripple + increment, 10 * increment);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		int x = 0;
		int y = 0;
		int base = 1;
		boolean foundUndefined = false;
		
		for(int loop = 0; (loop < this.busSize) && (!foundUndefined); loop++)
		{
			if(currentInputs[loop].isUndefined() || currentInputs[loop + this.busSize].isUndefined())
				foundUndefined = true;
			else
			{
				if(currentInputs[loop].getValue())
					x = x + base;
				
				if(currentInputs[loop + this.busSize].getValue())
					y = y + base;
			}
			
			base = 2 * base;
		}
		
		if(foundUndefined)
			peer.setOutputPinUndefined(0, time);
		else
			peer.setOutputPinValue(0, x < y, time);
	}
}