package sim.lib.wires;

import java.awt.*;

import sim.lib.EditBusSize;
import sim.*;
import sim.engine.*;

public class Fat2ThinFullSplitter extends RotatableFlippableWrapperPainted implements SplitterModule
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/wires/FullSplitterIcon.gif");
	
	public Image getIcon()
	{
		return Fat2ThinFullSplitter.ICON;
	}
	
	public Wrapper createWrapper()
	{
		return this.getCopy();
	}
	
	public Wrapper createWrapper(Point gridPosition)
	{
		Fat2ThinFullSplitter result = this.getCopy();
		result.setGridLocation(gridPosition);
		return result;
	}
	
	public String getBubbleHelp()
	{
		return "Full Wire Splitter";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Fat2ThinFullSplitter()
	{
		super();
		
		this.setBusSize(8);
	}
	
	private Fat2ThinFullSplitter getCopy()
	{
		Fat2ThinFullSplitter result = new Fat2ThinFullSplitter();
		result.setBusSize(this.busSize);
		
		return result;
	}
	
	public void initializeGridSize()
	{
		this.setGridSize(3, 10);
	}
	
/* ==================================================================
	Maintanance Part
	================================================================= */
	private Junction nodes[];
	private Junction bus = null;
	private int busSize = 2;
	
	public void setBusSize(int size)
	{
		this.busSize = size;
		
		this.nodes = new Junction[size];
		
		this.adjustToChanges();
	}
	
	public void selected()
	{
		for(int loop = 0; loop < this.busSize; loop++)
			this.nodes[loop].removePin();
		
		this.bus.removePin();
		
		this.changeColor(Color.green);
	}
	
	public void checkAfterSelected()
	{
		for(int loop = 0; loop < this.busSize; loop++)
			Wrapper.checkPin(this.nodes[loop]);
		
		Wrapper.checkPin(this.bus);
	}
	
/* ==================================================================
	Splitter Part
	================================================================= */
	public void mergeNodes(NodeList nodeList)
	{
		Node target, replaced;
		NodeList junctionPeer;
		WireList replacedWires;
		JunctionList replacedJunctions;
		int loop, where;
		
		for(int index = 0; index < this.busSize; index++)
		{
			target = this.bus.getNodes().getItemAt(index);
			replaced = this.nodes[index].getNodes().getItemAt(0);
			
			if(target != replaced)
			{
				nodeList.removeItem(replaced);
				
				replacedWires = replaced.getWires();
				for(loop = 0; loop < replacedWires.getSize(); loop++)
					target.addWire(replacedWires.getItemAt(loop));
				
				replacedJunctions = replaced.getJunctiions();
				for(loop = 0; loop < replacedJunctions.getSize(); loop++)
				{
					target.addJunction(replacedJunctions.getItemAt(loop));
					junctionPeer = replacedJunctions.getItemAt(loop).getNodes();
					
					where = junctionPeer.indexOf(replaced);
					
					if(where != -1)
						junctionPeer.changeItem(where, target);
				}
			}
		}
	}
	
/* ==================================================================
	Storage Part
	================================================================= */
	public String getSpecificParameters()
	{
		return (Integer.toString(this.busSize) + Wrapper.SEPARATOR);
	}
	
	public void loadWrapper(String[] specificParameters) throws SimException
	{
		if(specificParameters.length == this.getNumberOfSpecificParameters())
		{
			try
			{
				this.setBusSize(Integer.valueOf(specificParameters[0]).intValue());
			}
			catch(NumberFormatException e)
			{
				throw (new SimException("incorrect parameter type"));
			}
		}
		else
			throw (new SimException("incorrect number of parameters"));
	}
	
	public int getNumberOfSpecificParameters()
	{
		return 1;
	}
	
/* ==================================================================
	Rotation abd Flipping Part
	================================================================= */
	protected void paintNormal_0(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.height / 2;
		int middle = this.busSize / 2;
		
		g.setColor(this.brush);
		
		g.fillRect(0, center - 1, gridGap, 3);
		
		int up = gridGap;
		int left = 2 * gridGap;
		int right = 3 * gridGap;
		int loop = right / 4;
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, loop));
		g.drawString("0", left, loop);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(left, up, right, up);
			g.drawLine(gridGap, center, left, up);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(left, up, right, up);
			g.drawLine(gridGap, center, left, up);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(left, up, right, up);
				g.drawLine(gridGap, center, left, up);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(left, up, right, up);
				g.drawLine(gridGap, center, left, up);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintNormal_90(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.width / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int left = 2 * gridGap;
		int loop = gridGap / 4;
		
		g.setColor(this.brush);
		g.fillRect(center - 1, left, 3, gridGap);
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * loop));
		g.drawString("0", loop, gridGap);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(up, 0, up, gridGap);
			g.drawLine(up, gridGap, center, left);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(up, 0, up, gridGap);
			g.drawLine(up, gridGap, center, left);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(up, 0, up, gridGap);
				g.drawLine(up, gridGap, center, left);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(up, 0, up, gridGap);
				g.drawLine(up, gridGap, center, left);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintNormal_180(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.height / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int left = 2 * gridGap;
		int loop = gridGap / 4;
		
		g.setColor(this.brush);
		g.fillRect(left, center - 1, gridGap, 3);
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * loop));
		g.drawString("0", gridGap - loop, 2 * center - loop);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(0, up, gridGap, up);
			g.drawLine(left, center, gridGap, up);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(0, up, gridGap, up);
			g.drawLine(left, center, gridGap, up);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(0, up, gridGap, up);
				g.drawLine(left, center, gridGap, up);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(0, up, gridGap, up);
				g.drawLine(left, center, gridGap, up);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintNormal_270(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.width / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int right = 3 * gridGap;
		int loop = gridGap / 4;
		int left = 3 * loop;
		
		g.setColor(this.brush);
		g.fillRect(center - 1, 0, 3, gridGap);
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, left));
		g.drawString("0", 2 * center - left, gridGap * this.gridSize.height - loop);
		
		left = 2 * gridGap;
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(up, left, up, right);
			g.drawLine(up, left, center, gridGap);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(up, left, up, right);
			g.drawLine(up, left, center, gridGap);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(up, left, up, right);
				g.drawLine(up, left, center, gridGap);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(up, left, up, right);
				g.drawLine(up, left, center, gridGap);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintFlipped_0(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.height / 2;
		int middle = this.busSize / 2;
		
		g.setColor(this.brush);
		
		g.fillRect(0, center - 1, gridGap, 3);
		
		int up = gridGap;
		int left = 2 * gridGap;
		int right = gridGap / 4;
		int loop = 3 * right;
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, loop));
		g.drawString("0", left, 2 * center - right);
		
		right = 3 * gridGap;
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(left, up, right, up);
			g.drawLine(gridGap, center, left, up);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(left, up, right, up);
			g.drawLine(gridGap, center, left, up);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(left, up, right, up);
				g.drawLine(gridGap, center, left, up);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(left, up, right, up);
				g.drawLine(gridGap, center, left, up);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintFlipped_90(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.width / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int left = 2 * gridGap;
		int right = 3 * gridGap;
		int loop = gridGap / 4;
		
		g.setColor(this.brush);
		g.fillRect(center - 1, 0, 3, gridGap);
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * loop));
		g.drawString("0", loop, gridGap * this.gridSize.height - loop);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(up, left, up, right);
			g.drawLine(up, left, center, gridGap);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(up, left, up, right);
			g.drawLine(up, left, center, gridGap);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(up, left, up, right);
				g.drawLine(up, left, center, gridGap);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(up, left, up, right);
				g.drawLine(up, left, center, gridGap);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintFlipped_180(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.height / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int left = gridGap / 4;
		int loop = 3 * left;
		
		g.setColor(this.brush);
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, loop));
		g.drawString("0", gridGap - left, loop);
		
		left = 2 * gridGap;
		
		g.fillRect(left, center - 1, gridGap, 3);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(0, up, gridGap, up);
			g.drawLine(left, center, gridGap, up);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(0, up, gridGap, up);
			g.drawLine(left, center, gridGap, up);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(0, up, gridGap, up);
				g.drawLine(left, center, gridGap, up);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(0, up, gridGap, up);
				g.drawLine(left, center, gridGap, up);
				up = up + gridGap;
			}
		}
	}
	
	protected void paintFlipped_270(Graphics g)
	{
		int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
		int center = gridGap * this.gridSize.width / 2;
		int middle = this.busSize / 2;
		
		int up = gridGap;
		int left = 2 * gridGap;
		int loop = 3 * gridGap / 4;
		
		g.setColor(this.brush);
		g.fillRect(center - 1, left, 3, gridGap);
		
		g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, loop));
		
		g.drawString("0", 2 * center - loop, gridGap);
		
		for(loop = 0; loop < middle; loop++)
		{
			g.drawLine(up, 0, up, gridGap);
			g.drawLine(up, gridGap, center, left);
			up = up + gridGap;
		}
		
		if((this.busSize % 2 ) != 0)
		{
			g.drawLine(up, 0, up, gridGap);
			g.drawLine(up, gridGap, center, left);
			up = up + gridGap;
			
			for(loop = middle + 1; loop < this.busSize; loop++)
			{
				g.drawLine(up, 0, up, gridGap);
				g.drawLine(up, gridGap, center, left);
				up = up + gridGap;
			}
		}
		else
		{
			up = up + gridGap;
			
			for(loop = middle; loop < this.busSize; loop++)
			{
				g.drawLine(up, 0, up, gridGap);
				g.drawLine(up, gridGap, center, left);
				up = up + gridGap;
			}
		}
	}
	
	
	
	
	protected boolean canDropNormal_0()
	{
		boolean result = true;
		int middle = this.busSize / 2;
		int loop;
		
		// check nodes
		for(loop = 0; (loop < middle) && result; loop++)
			result = Wrapper.canDropJuncion(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
		
		if(result)
		{
			if((this.busSize % 2) != 0)
			{
				result = Wrapper.canDropJuncion(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, 1);
				for(loop = middle + 1; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
			}
			else
			{
				for(loop = middle; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 2 + loop, 1);
			}
		}
		
		// check bus
		if(result)
			result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 1 + middle, this.busSize);
		
		return result;
	}
	
	protected boolean canDropNormal_90()
	{
		boolean result = true;
		int middle = this.busSize / 2;
		int loop;
		
		// check nodes
		for(loop = 0; (loop < middle) && result; loop++)
			result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
		
		if(result)
		{
			if((this.busSize % 2) != 0)
			{
				result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + middle, this.gridLocation.y, 1);
				for(loop = middle + 1; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
			}
			else
			{
				for(loop = middle; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + 2 + loop, this.gridLocation.y, 1);
			}
		}
		
		// check bus
		if(result)
			result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, this.busSize);
		
		return result;
	}
	
	protected boolean canDropNormal_180()
	{
		boolean result = true;
		int middle = this.busSize / 2;
		int loop;
		
		// check nodes
		for(loop = 0; (loop < middle) && result; loop++)
			result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
		
		if(result)
		{
			if((this.busSize % 2) != 0)
			{
				result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 1 + middle, 1);
				for(loop = middle + 1; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
			}
			else
			{
				for(loop = middle; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 2 + loop, 1);
			}
		}
		
		// check bus
		if(result)
			result = Wrapper.canDropJuncion(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, this.busSize);
		
		return result;
	}
	
	protected boolean canDropNormal_270()
	{
		boolean result = true;
		int middle = this.busSize / 2;
		int loop;
		
		// check nodes
		for(loop = 0; (loop < middle) && result; loop++)
			result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
		
		if(result)
		{
			if((this.busSize % 2) != 0)
			{
				result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, 1);
				for(loop = middle + 1; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
			}
			else
			{
				for(loop = middle; (loop < this.busSize) && result; loop++)
					result = Wrapper.canDropJuncion(this.gridLocation.x + 2 + loop, this.gridLocation.y + this.gridSize.height, 1);
			}
		}
		
		// check bus
		if(result)
			result = Wrapper.canDropJuncion(this.gridLocation.x + 1 + middle, this.gridLocation.y, this.busSize);
		
		return result;
	}
	
	protected boolean canDropFlipped_0()
	{
		return this.canDropNormal_0();
	}
	
	protected boolean canDropFlipped_90()
	{
		return this.canDropNormal_270();
	}
	
	protected boolean canDropFlipped_180()
	{
		return this.canDropNormal_180();
	}
	
	protected boolean canDropFlipped_270()
	{
		return this.canDropNormal_90();
	}
	
	
	
	
	protected void dropedNormal_0()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 2 + loop, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + middle, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedNormal_90()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 2 + loop, this.gridLocation.y, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedNormal_180()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + middle, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 2 + loop, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedNormal_270()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 2 + loop, this.gridLocation.y + this.gridSize.height, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedFlipped_0()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + loop, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 2 + loop, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + middle, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedFlipped_90()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y + this.gridSize.height, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x + 2 + loop, this.gridLocation.y + this.gridSize.height, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedFlipped_180()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + middle, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 1 + loop, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[loop] = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 2 + loop, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + this.gridSize.width, this.gridLocation.y + 1 + middle, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	protected void dropedFlipped_270()
	{
		int loop;
		int middle = this.busSize / 2;
		
		for(loop = 0; loop < middle; loop++)
			this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
		
		if((this.busSize % 2) != 0)
		{
			this.nodes[middle] = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y, 1);
			for(loop = middle + 1; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 1 + loop, this.gridLocation.y, 1);
		}
		else
		{
			for(loop = middle; loop < this.busSize; loop++)
				this.nodes[this.busSize - 1 - loop] = Wrapper.setPinAt(this.gridLocation.x + 2 + loop, this.gridLocation.y, 1);
		}
		
		this.bus = Wrapper.setPinAt(this.gridLocation.x + 1 + middle, this.gridLocation.y + this.gridSize.height, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
		
	
	
	
	protected void adjustToChanges()
	{
		if(this.angle % 180 == 0)
			this.setGridSize(3, 2 * (this.busSize / 2) + 2);
		else
			this.setGridSize(2 * (this.busSize / 2) + 2, 3);
	}
	
/* ==================================================================
	Popup Part
	================================================================= */
	private int oldBusSize = 0;
	
	public boolean hasProperties()
	{
		return true;
	}
	
	public Component getPropertyWindow()
	{
		return (new EditBusSize(this.busSize));
	}
		
	public void respondToChanges(Component property)
	{
		if(this.oldBusSize == 0)
			this.oldBusSize = this.busSize;
		
		CentralPanel.ACTIVE_GRID.eraseComponent(this);
		this.setBusSize(((EditBusSize)property).getBusSize());
		CentralPanel.ACTIVE_GRID.paintComponent(this);
	}
	
	public void restoreOriginalProperties()
	{
		if(this.oldBusSize != 0)
		{
			this.setBusSize(this.oldBusSize);
			this.oldBusSize = 0;
		}
	}
}                                                                                                                                         
