package sim.lib.wires;

import java.awt.*;
import java.util.Vector;

import sim.*;
import sim.engine.*;

public class WireList extends Vector
{
	public WireList(int size)
	{
		super(size);
		
		this.setSize(size);
	}
	
	public WireList()
	{
		super();
	}
		
	public int getSize()
	{
		return super.size();
	}
	
	public Wire getItemAt(int index)
	{		
		return (Wire)super.elementAt(index);
	}
	
	public void removeItemAt(int index)
	{
		super.removeElementAt(index);
	}
	
	public void removeItem(Wire oldValue)
	{
		super.removeElement(oldValue);
	}
	
	public void removeAll()
	{
		super.removeAllElements();
	}
	
	public void changeItem(int index, Wire newValue)
	{
		super.setElementAt(newValue, index);
	}
	
	public void resetItem(int index)
	{
		super.setElementAt(null, index);
	}
	
	public void insertItem(Wire newValue)
	{
		super.addElement(newValue);
	}
	
	public void insertItemAt(int index, Wire newValue)
	{
		super.insertElementAt(newValue, index);
	}
	
	public boolean contains(Wire value)
	{
		return super.contains(value);
	}
	
	public void insertDistinctItem(Wire newValue)
	{	
		if(!this.contains(newValue))
			this.insertItem(newValue);
	}
	
	public void respond(Data value)
	{
		if(!this.isEmpty())
		{
			Rectangle oldBounds = this.getItemAt(0).getBounds();
			
			if(value.isUndefined())
			{
				for(int loop = 0; loop < this.getSize(); loop++)
				{
					this.getItemAt(loop).respondToUndefined();
					CentralPanel.ACTIVE_GRID.paintComponent(this.getItemAt(loop), false);
					oldBounds = oldBounds.union(this.getItemAt(loop).getBounds());
				}
			}
			else if(value.getValue())
			{
				for(int loop = 0; loop < this.getSize(); loop++)
				{
					this.getItemAt(loop).respondToTrue();
					CentralPanel.ACTIVE_GRID.paintComponent(this.getItemAt(loop), false);
					oldBounds = oldBounds.union(this.getItemAt(loop).getBounds());
				}
			}
			else
			{
				for(int loop = 0; loop < this.getSize(); loop++)
				{
					this.getItemAt(loop).respondToFalse();
					CentralPanel.ACTIVE_GRID.paintComponent(this.getItemAt(loop), false);
					oldBounds = oldBounds.union(this.getItemAt(loop).getBounds());
				}
			}
			
			CentralPanel.ACTIVE_GRID.blitWorkplaceToScreen(oldBounds);
		}
	}
	
	public void reset()
	{
		if(!this.isEmpty())
		{
			for(int loop = 0; loop < this.getSize(); loop++)
			{
				this.getItemAt(loop).reset();
				CentralPanel.ACTIVE_GRID.paintComponent(this.getItemAt(loop), false);
			}
		}
	}
}
