package sim.util;

import java.awt.*;

public class BubbleWaitThread extends Thread
{
	private long wait = Long.MAX_VALUE;
	private long start;
	private boolean toShow = false;
	
	public static SimBubble BUBBLE_WINDOW;
	
	public BubbleWaitThread()
	{
		super();
		this.setPriority(Thread.MIN_PRIORITY);
	}
	
	public void run()
	{
		this.suspend();
		
		while(true)
		{
			long delta = System.currentTimeMillis() - start;
			if(delta > this.wait)
			{
				if(this.setShow(this.toShow))
					BubbleWaitThread.BUBBLE_WINDOW.setVisible(true);
				
				this.suspend();
			}
		}
	}
	
	public void reset(String help, Component parent, long time)
	{
		BubbleWaitThread.BUBBLE_WINDOW.dispose();
		BubbleWaitThread.BUBBLE_WINDOW.setText(help);
		
		Dimension size = parent.getSize();
   		Point scrnLoc = parent.getLocationOnScreen();
		BubbleWaitThread.BUBBLE_WINDOW.setLocation(scrnLoc.x, scrnLoc.y + size.height + 2);
		
		this.start = System.currentTimeMillis();
		this.wait = time;
		
		this.setShow(true);
		super.resume();
	}
	
	public void halt()
	{
		BubbleWaitThread.BUBBLE_WINDOW.dispose();
		
		this.setShow(false);
	}
	
	private synchronized boolean setShow(boolean b)
	{
		this.toShow = b;
		return this.toShow;
	}
}