package sim.util;

import java.awt.*;
import java.awt.event.*;

public class SimBubble extends Window
{
	private BubblePanel label =new BubblePanel();
	
	public SimBubble(Frame f)
	{
		super(f); 
		this.setBackground(new Color(255, 255, 218));
		this.add(this.label, BorderLayout.CENTER);
	}
	
	public void setVisible(boolean b)
	{
		this.pack();
		super.setVisible(b);
	}
	
	public void setText(String s)
	{
		this.label.setText(" " + s + " ");
	}
	
	private class BubblePanel extends Container
	{
		private String text;
	
		public BubblePanel()
		{
			super();
			this.setForeground(Color.black);
		}
		
		public void setText(String s)
		{
			this.text = s;
		}
		
		public void paint(Graphics g)
		{
			Dimension size = this.getSize();
			FontMetrics fm = g.getFontMetrics();
			
			g.drawRect(0, 0, size.width - 1, size.height - 1);
			g.drawString(this.text, 2, fm.getAscent() + 2);
		}
		
		public Dimension getPreferredSize()
		{
			Graphics g = this.getGraphics();
			FontMetrics fm = g.getFontMetrics();
			
			return (new Dimension(fm.stringWidth(this.text) + 4, fm.getHeight() + 4));
		}
	}
}
