package sim.lib;

import java.awt.*;
import java.awt.event.*;

import sim.util.SimSeparator;

public class EditBusSize extends Container implements ActionListener
{
	private TextField editBus = new TextField(10);
	private Label pins = new Label("Pins");
	private int old;
	
	public EditBusSize(int initial)
	{
		super();
		this.setLayout(new BorderLayout(0, 15));
		
		this.old = initial;
		
		Panel p = new Panel(new BorderLayout());
		p.add(this.pins, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		this.add(p, BorderLayout.NORTH);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Bus Size"));
		p.add(this.editBus);
		this.add(p, BorderLayout.CENTER);
		
		this.editBus.addActionListener(this);
		this.editBus.setText(Integer.toString(initial));
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.setSize(290, this.editBus.getPreferredSize().height + this.pins.getPreferredSize().height + 15);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		int newBus;
		
		try
		{
			newBus = Integer.valueOf(this.editBus.getText()).intValue();
			
			if(newBus < 2)
				this.editBus.setText(Integer.toString(this.old));
			else
				this.old = newBus;
		}
		catch(NumberFormatException nfe)
		{
			this.editBus.setText(Integer.toString(this.old));
		}
	}
	
	public int getBusSize()
	{
		int newBus;
		
		try
		{
			newBus = Integer.valueOf(this.editBus.getText()).intValue();
			
			if(newBus >= 2)
				this.old = newBus;
		}
		catch(NumberFormatException nfe)
		{
		}
		
		return this.old;
	}
	
	public Dimension getPreferredSize()
	{
		return this.getSize();
	}
	
	public Dimension getMinimumSize()
	{
		return this.getSize();
	}

	public Dimension getMaximumSize()
	{
		return this.getSize();
	}
}