package sim.util;

import java.awt.event.*;

public class SpringyLightButtonListener extends MouseAdapter implements MouseMotionListener
{
	public void activate(LightButton lb)
	{	
		if(!lb.isRaised())
			lb.setRaised();
		
		lb.setArmed(false);
		
		lb.processActionEvent();
	}
	
	public void arm(LightButton lb)
	{
		if(!lb.isInset())
			lb.setInset();
		
		lb.setArmed(true);
	}
	
	public void disarm(LightButton lb)
	{
		if(!lb.isRaised())
			lb.setRaised();
		
		lb.setArmed(false);
	}
	
	public void mousePressed(MouseEvent me)
	{
		LightButton lb = (LightButton)me.getComponent();
		
		if(lb.isEnabled())
			this.arm(lb);
	}
	
	public void mouseClicked(MouseEvent me)
	{
		LightButton lb = (LightButton)me.getComponent();
		
		if(lb.isEnabled() && lb.isArmed())
			this.activate(lb);
	}
	
	public void mouseReleased(MouseEvent me)
	{
		LightButton lb = (LightButton)me.getComponent();
		
		if(lb.contains(me.getPoint().x, me.getPoint().y))
			this.mouseClicked(me);
	}
	
	public void mouseDragged(MouseEvent me)
	{
		LightButton lb = (LightButton)me.getComponent();
		
		if(lb.isEnabled())
		{
			int x = me.getPoint().x; 
			int y = me.getPoint().y;

        	if(lb.contains(x,y))
				this.arm(lb);
        	else
				this.disarm(lb);
		}
	}
	
	public void mouseMoved(MouseEvent event)
	{
	}
}
